/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.helper;

import com.intellij.ide.Prefs;
import io.zhile.research.intellij.ier.common.Resetter;
import io.zhile.research.intellij.ier.helper.Constants;
import io.zhile.research.intellij.ier.helper.DateTime;

public class ResetTimeHelper {
    public static final long RESET_PERIOD = 2160000000L;
    private static final String RESET_KEY = "Ide-Eval-Reset.reset_time." + Constants.IDE_NAME + Constants.IDE_BASELINE_VERSION;

    public static long getLastResetTime() {
        return Prefs.getLong((String)RESET_KEY, (long)0L);
    }

    public static void resetLastResetTime() {
        Prefs.putLong((String)RESET_KEY, (long)System.currentTimeMillis());
        Resetter.syncPrefs();
    }

    public static boolean overResetPeriod() {
        return System.currentTimeMillis() - ResetTimeHelper.getLastResetTime() > 2160000000L;
    }

    public static String getLastResetTimeStr() {
        long lastResetTime = ResetTimeHelper.getLastResetTime();
        return lastResetTime > 0L ? DateTime.getStringFromTimestamp(lastResetTime) : "Not yet";
    }
}

