/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.helper;

import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import org.jetbrains.annotations.NotNull;

public class ErrorReporter
extends ErrorReportSubmitter {
    private static final String NEW_ISSUE_URL = "https://gitee.com/pengzhile/ide-eval-resetter/issues/new";

    public String getReportActionText() {
        return "Open Browser to Submit This Issue...";
    }

    public String getPrivacyNoticeText() {
        return "Click the submit button will <b>write the stacktrace text to your clipboard</b>!<br>So that you can paste it directly when writing the issue.";
    }

    public boolean submit(IdeaLoggingEvent[] events, String additionalInfo, @NotNull Component parentComponent, @NotNull Consumer consumer) {
        if (parentComponent == null) {
            ErrorReporter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            ErrorReporter.$$$reportNull$$$0(1);
        }
        int length = events.length - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= length; ++i) {
            sb.append(events[i].getThrowableText());
            if (i == length) continue;
            sb.append("\n\n\n");
        }
        try {
            Desktop.getDesktop().browse(new URI(NEW_ISSUE_URL));
            StringSelection selection = new StringSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
            consumer.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.NEW_ISSUE));
        }
        catch (Exception e) {
            consumer.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parentComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "io/zhile/research/intellij/ier/helper/ErrorReporter";
        objectArray[2] = "submit";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

